package tech.espublico.pades.server.di;

public class ServiceEntry {

	private final String name;
	private final Class<?> serviceClass;

	public ServiceEntry(Class<?> serviceClass) {
		this.serviceClass = serviceClass;
		this.name = serviceClass.getCanonicalName();
	}

	public String getName() {
		return name;
	}

	public Class<?> getServiceClass() {
		return serviceClass;
	}
}
