package tech.espublico.pades.server;

import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class CommandLineOptions {

	public static Options configureOptions() {
		Options options = new Options();

		options.addOption(// config
				Option.builder("c").longOpt("config").argName("path-config-properties").hasArg().required() //
						.desc("(require) path to server configuration").build());
		options.addOption( // logback
				Option.builder("l").longOpt("logback").argName("path-logback").hasArg().required() //
						.desc("(require) path to logback file configuration").build());

		return options;
	}

	protected static void printHelp(Options options) {
		new HelpFormatter().printHelp("Espublico Pades Server", options);
		System.exit(0);
	}
}