package tech.espublico.pades.server;

import java.nio.file.Path;
import java.nio.file.Paths;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import tech.espublico.pades.server.di.ServiceLocator;
import tech.espublico.pades.server.rest.RoutesService;
import tech.espublico.pades.server.services.AppUtils;
import tech.espublico.pades.server.services.ConfigService;
import tech.espublico.pades.server.services.PadesComponents;
import tech.espublico.pades.server.services.scheduler.SchedulerService;

public class App {

	private static final Logger log = LoggerFactory.getLogger(App.class);

	public static void main(String[] args) {
		Options options = CommandLineOptions.configureOptions();

		if (args.length == 0) {
			CommandLineOptions.printHelp(options);
		}

		try {
			CommandLineParser parser = new DefaultParser();
			CommandLine cmd = parser.parse(options, args);

			Path configPath = Paths.get(cmd.getOptionValue("c"));
			Path logback = Paths.get(cmd.getOptionValue("l"));

			ConfigService.setDirectConfigURL(configPath.toString());
			ConfigService.startLogBack(logback.toString());
			ServiceLocator.INSTANCE.register(ConfigService.class);
			ConfigService.instance();
			PadesComponents.register();

			ServiceLocator.INSTANCE.instantiateAll();
			SchedulerService.instance().start();
			RoutesService.instance().start();

			AppUtils.waitToExit("Espublico Pades Server", App::shutdown);
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(1);
		}
	}

	/**
	 * Controlled stop
	 *
	 * @throws RuntimeException
	 * 		if anything happends to the stopping process. If anything happends it's possible to kill the server.
	 */
	private static void shutdown() {
		log.info("Stopping Espublico Pades Server");
		try {
			SchedulerService.instance().stop();
			RoutesService.instance().stop();
		} catch (Exception e) {
			log.error("Error stopping Espublico Pades: " + e.getMessage(), e);
			throw new RuntimeException("Error stopping Espublico Pades: " + e.getMessage(), e);
		}
	}
}
